##################################################################
# R code: Exercise 6.8
# File: exercise_6-8.r
##################################################################
library(tsDyn)
set.seed(1234)
nsim  <- 100                        # 100 Monte Carlo replications
yy   <- matrix(nrow=200,ncol=nsim)  # initialize
y    <- matrix(nrow=300,ncol=1)
f    <- matrix(nrow=300,ncol=1)
ynew <- matrix(nrow=200,ncol=1)
for (it in 1:nsim){
   y[1] <- 0            # starting condition
   f[1] <- 0
   u    <- rnorm(300)    
   for(i in 2:300){
        f[i] <- 1/(1+exp(-10*(y[i-1]-5)))
        y[i] <- (1+0.9*y[i-1])+(3-1.7*y[i-1])*f[i]+u[i]
   }
   ynew    <- y[101:300]        # effective sample size is T=200
   yy[,it] <- cbind(ynew)
} 
coeff <- array(1,c(6,1,nsim))   # 6 parameters
for(j in 1:nsim) {   
    mod.lstar <- lstar(yy[,j],m=2,d=1,mL=1,mH=1,mTh=c(0,1),
                   starting.control=list(gammaInt=c(0,20),
                   nGamma=100))
# Restricting the initial value of gamma to the interval
# (0,20), and setting the number of smoothing values 
# (gamma) in the grid at 100              
    coeff[,,j] <- mod.lstar$coefficients
 }
tot <- cbind(coeff[1,,],coeff[2,,],coeff[3,,],coeff[4,,],
             coeff[5,,],coeff[6,,])   
meantotal <- c(6)   # initialize
stdtotal  <- c(6)
for(j in 1:6){              
    meantotal[j] <- mean(coeff[j,,]) # mean  
    stdtotal[j]  <- sd(coeff[j,,])   # standard deviation
}
